﻿namespace Hims.Api.Senders
{
    using System;
    using System.Threading.Tasks;
    using Hims.Shared.EntityModels;
    using Hims.Shared.Library;

    /// <summary>
    /// The SMSSender interface.
    /// </summary>
    public interface ISMSSender
    {
        /// <summary>
        /// The send OTP async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="countryId">
        /// The country Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<OTPResponse> SendOTPAsync(string mobile, int countryId, string otp);

        /// <summary>
        /// The send SMS async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="countryId">
        /// The country id.
        /// </param>
        /// <param name="message">
        /// The message.
        /// </param>
        /// <param name="templateId">
        /// The message.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendSMSAsync(string mobile, int countryId, string message, string templateId);

        /// <summary>
        /// The send welcome message async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="fullName">
        /// The full Name.
        /// </param>
        /// <param name="password">
        /// The password.
        /// </param>
        /// <param name="createPasswordLink">
        /// The create Password Link.
        /// </param>
        /// <param name="countryId">
        /// The country Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendWelcomeMessageAsync(string mobile, string fullName, string password, string createPasswordLink, int countryId);

        /// <summary>
        /// The send ticket message async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="ticketNumber">
        /// The ticket number.
        /// </param>
        /// <param name="countryId">
        /// The country Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendTicketMessageAsync(string mobile, string ticketNumber, int countryId);

        /// <summary>
        /// The send ticket message async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="ticketNumber">
        /// The ticket number.
        /// </param>
        /// <param name="countryId">
        /// The country Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendPanicTicketMessageAsync(string mobile, string ticketNumber, int countryId);

        /// <summary>
        /// The send ticket message async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="ticketNumber">
        /// The ticket number.
        /// </param>
        /// <param name="countryId">
        /// The country Id.
        /// </param>
        /// <param name="message">
        /// The message.
        /// </param>
        /// <param name="templateId">
        /// The template id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendPanicTicketMessageToUserAsync(string mobile, string ticketNumber, int countryId, string message, string templateId);

        /// <summary>
        /// The send ticket closed message async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="ticketNumber">
        /// The ticket number.
        /// </param>
        /// <param name="countryId">
        /// The country id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendTicketClosedMessageAsync(string mobile, string ticketNumber, int countryId);

        /// <summary>
        /// The send appointment message async.
        /// </summary>
        /// <param name="appointment">
        /// The appointment.
        /// </param>
        /// <param name="messageType">
        /// The message Type.
        /// </param>
        /// <param name="displayTime">
        /// The display time.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendAppointmentMessageAsync(AppointmentModel appointment, string messageType, string displayTime);

        /// <summary>
        /// The send payment message async.
        /// </summary>
        /// <param name="appointment">
        /// The appointment.
        /// </param>
        /// <param name="displayTime">
        /// The display time.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendPaymentMessageAsync(AppointmentModel appointment, string displayTime);

        /// <summary>
        /// The send reset password async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="fullName">
        /// The full Name.
        /// </param>
        /// <param name="accountType">
        /// The account Type.
        /// </param>
        /// <param name="resetPasswordLink">
        /// The reset Password Link.
        /// </param>
        /// <param name="countryId">
        /// The country Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendResetPasswordAsync(string mobile, string fullName, string accountType, string resetPasswordLink, int countryId);

        /// <summary>
        /// The send create password async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="fullName">
        /// The full Name.
        /// </param>
        /// <param name="createPasswordLink">
        /// The create Password Link.
        /// </param>
        /// <param name="countryId">
        /// The country Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendCreatePasswordAsync(string mobile, string fullName, string createPasswordLink, int countryId);

        /// <summary>
        /// The send video link async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="countryId">
        /// The country id.
        /// </param>
        /// <param name="link">
        /// The link.
        /// </param>
        /// <param name="patientName">
        /// The patient name.
        /// </param>
        /// <param name="providerName">
        /// The provider name.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendVideoLinkAsync(string mobile, int countryId, string link, string patientName, string providerName);

        /// <summary>
        /// The send referral code link async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="countryId">
        /// The country id.
        /// </param>
        /// <param name="referralCode"></param>
        /// <param name="fullName"></param>
        /// <param name="link">
        /// The link.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendReferralCodeSMSAsync(string mobile, int countryId, string referralCode, string fullName, string link);

        /// <summary>
        /// The send referral code link async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="countryId">
        /// The country id.
        /// </param>
        /// <param name="fullName"></param>
        /// <param name="iosLink">
        ///  /// <param name="androidlink">
        /// The link.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendReferralLinkAsync(string mobile, int countryId, string fullName, string iosLink, string androidlink);

        /// <summary>
        /// The send referral code link async.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="countryId">
        /// The country id.
        /// </param>
        /// <param name="fullName"></param>
        /// <param name="iosLink">
        ///  /// <param name="androidlink">
        /// The link.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<bool> SendRescheduleInfoToProviderAsync(string mobile, string providerName, string patientName, int countryId, string date, string displayTime);

        /// <summary>
        /// Sends the lab report SMS.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="patientName">Name of the patient.</param>
        /// <param name="url">The URL.</param>
        /// <returns></returns>
        Task<System.Tuple<bool, string>> SendLabReportSms(string mobile, string patientName, string url);
        Task<bool> SendPdfLinkSms(string patientMobile, object patientName, string createPdfLink);
    }
}
